<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\ParcelShop;

use Gls\GlsPoland\AdePlus\Authorization\AuthorizedRequest;

final class SearchById extends AuthorizedRequest
{
    /**
     * @var string
     */
    private $id;

    public function __construct(string $id)
    {
        $this->id = $id;
    }

    public function jsonSerialize(): array
    {
        return [
            'id' => $this->id,
        ];
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function withId(string $id): SearchById
    {
        $new = clone $this;
        $new->id = $id;

        return $new;
    }
}
