<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Printout;

final class Label implements NamedPrintoutInterface
{
    private $number;

    private $file;

    private function __construct(string $parcelNumber, string $contents)
    {
        $this->number = $parcelNumber;
        $this->file = $contents;
    }

    public function getParcelNumber(): string
    {
        return $this->number;
    }

    /**
     * {@inheritdoc}
     */
    public function getContents(): string
    {
        return $this->file;
    }

    public function getFileName(): string
    {
        return $this->number;
    }
}
