<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;
use Gls\GlsPoland\Soap\Client\Type\ResultProviderInterface;

/**
 * @template T of ResultInterface
 */
abstract class Response implements ResultProviderInterface, \JsonSerializable
{
    protected $return;

    final private function __construct(ResultInterface $return)
    {
        $this->return = $return;
    }

    /**
     * @return T
     */
    public function getResult(): ResultInterface
    {
        return $this->return;
    }

    public function jsonSerialize(): array
    {
        return $this->return;
    }
}
