<?php

declare(strict_types=1);

namespace Gls\GlsPoland\MessageHandler\Labels\Download;

use Gls\GlsPoland\AdePlus\PreparingBox\ClientInterface;
use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;
use Gls\GlsPoland\AdePlus\Printout\PrintoutInterface;
use Gls\GlsPoland\Entity\Consignment;
use Gls\GlsPoland\EventDispatcher\EventDispatcherInterface;
use Gls\GlsPoland\MessageHandler\Labels\LabelsEvent;

final class PreparingBoxDownloadLabelsHandler extends AbstractDownloadLabelsHandler
{
    private $client;
    private $dispatcher;

    public function __construct(ClientInterface $client, EventDispatcherInterface $dispatcher)
    {
        $this->client = $client;
        $this->dispatcher = $dispatcher;
    }

    public function downloadSingle(Consignment $consignment, LabelsPrintMode $printMode): PrintoutInterface
    {
        $labels = $this->client->getLabels($consignment->getPreparingBoxId(), $printMode);
        $this->dispatcher->dispatch(new LabelsEvent($consignment), LabelsEvent::PREP_BOX_DOWNLOADED);

        return $labels;
    }

    public function downloadSeparate(Consignment $consignment, LabelsPrintMode $printMode): iterable
    {
        $labels = $this->client->getSeparateLabels($consignment->getPreparingBoxId(), $printMode);
        $this->dispatcher->dispatch(new LabelsEvent($consignment), LabelsEvent::PREP_BOX_DOWNLOADED);

        return $labels;
    }
}
