<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Grid\Column;

use PrestaShop\PrestaShop\Core\Grid\Column\AbstractColumn;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @internal
 */
final class LegacyLinkColumn extends AbstractColumn
{
    public function getType(): string
    {
        return 'gls_poland_legacy_link';
    }

    protected function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver);

        $resolver
            ->setDefaults([
                'extra_route_params' => [],
            ])
            ->setRequired([
                'field',
                'route',
                'route_param_name',
                'route_param_field',
            ])
            ->setAllowedTypes('field', 'string')
            ->setAllowedTypes('route', 'string')
            ->setAllowedTypes('route_param_name', 'string')
            ->setAllowedTypes('route_param_field', 'string')
            ->setAllowedTypes('extra_route_params', 'array');
    }
}
