<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Message;

class ImportTranslationsCommand
{
    private $directory;

    public function __construct(string $directory)
    {
        if (!is_dir($directory)) {
            throw new \InvalidArgumentException(sprintf('Directory "%s" does not exist.', $directory));
        }

        $this->directory = $directory;
    }

    public function getDirectory(): string
    {
        return $this->directory;
    }
}
