<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\ExtSoapEngine\Exception;

use Gls\GlsPoland\Soap\Engine\Exception\RuntimeException;

final class RequestException extends RuntimeException
{
    public static function noRequestRegistered(): self
    {
        return new self('No request has been registered yet.');
    }

    public static function internalSoapError(string $lastError): self
    {
        return new self('Internal ext-soap error: ' . $lastError);
    }
}
