<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\ExtSoapEngine\Transport;

use Gls\GlsPoland\Soap\Engine\HttpBinding\SoapRequest;
use Gls\GlsPoland\Soap\Engine\HttpBinding\SoapResponse;
use Gls\GlsPoland\Soap\Engine\TransportInterface;
use Gls\GlsPoland\Soap\ExtSoapEngine\AbusedClient;

final class ExtSoapClientTransport implements TransportInterface
{
    /**
     * @var AbusedClient
     */
    private $client;

    public function __construct(AbusedClient $client)
    {
        $this->client = $client;
    }

    public function request(SoapRequest $request): SoapResponse
    {
        $response = $this->client->doActualRequest(
            $request->getRequest(),
            $request->getLocation(),
            $request->getAction(),
            $request->getVersion(),
            $request->getOneWay()
        );

        return new SoapResponse($response);
    }
}
